 ; Ŀ
 ;   Splurge - Purge a drawing using the purge command.                    
 ;   Copyright 1995, 2004, 2009 by Rocket Software Ltd.                    
 ;   New from Rocket - self igniting bridge incendiaries.                  
 ; 
 (defun c:splurge (/ urgep num)
  (setvar "clayer" "0")
  (command "qsave")
  (setvar "cmdecho" 1)
  (setq urgep T)
  (setq num 0)
  (while urgep
        (command "purge" "a")
        (command "*")
        (command "y")
        (setq urgep ())
        (while (/= 0 (getvar "cmdactive"))
               (setq num (1+ num))
               (setq urgep T)
               (command "Y")))
  (setvar "cmdecho" 0)
  (write-line (strcat (itoa num) " thing" (if (= num 1) "" "s") " purged."))
 ; Ŀ
 ;   If the acad version is 2007 or later, purge unused applications.      
 ;   The AcadVer system variable contains the release, sort of.            
 ;   15.05 = 2000i                                                         
 ;   15.06 = 2002                                                          
 ;   16.0 = 2004                                                           
 ;   16.1 = 2005                                                           
 ;   16.2 = 2006                                                           
 ;   17.0 = 2007                                                           
 ;   17.1s (LMS Tech) = 2008                                               
 ;   17.2s (LMS Tech) = 2009                                               
 ;   All of these are off the net and thus unverified.                     
 ;                                                                         
 ;   Note: this will sometimes pop up a corrupt drawing error,             
 ;   so it won't run during a script.                                      
 ; 
  (if (and (/= 4 (logand 4 (getvar "cmdactive")))           ; script active?
           (>= (read (substr (getvar "acadver") 1 2)) 17))  ; version
      (command "-purge" "r" "*" "n"))                       ; purge regapps
  (command "resume")
 (princ))
